VERSION 5.00
Begin VB.UserControl ctlAsyncTransfer 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   InvisibleAtRuntime=   -1  'True
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "ctlAsyncTransfer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private mcolFiles As Collection
Private mcolData As Collection


Event FileReadComplete( _
    ByVal strFileKey As String, _
    ByVal lngFileType As enumDownloadFileTypes, _
    AsyncProp As AsyncProperty, _
    ByVal strData As String)
Attribute FileReadComplete.VB_Description = "Fires when a transfer is complete"

Event FileReadProgress( _
    ByVal strFileKey As String, _
    ByVal lngFileType As enumDownloadFileTypes, _
    AsyncProp As AsyncProperty, _
    ByVal strData As String)
Attribute FileReadProgress.VB_Description = "Fires when some progress has been made in the transfer"
    
Private Function GetFileKey(ByVal strFileKey As String) As String
GetFileKey = Left(strFileKey, InStr(strFileKey, "|") - 1)
End Function
Private Function GetFileType(ByVal strFileKey As String) As Long
GetFileType = CLng(Mid(strFileKey, InStr(strFileKey, "|") + 1))
End Function

Private Sub UserControl_AsyncReadComplete(AsyncProp As AsyncProperty)
Dim strData As String
strData = mcolData(AsyncProp.PropertyName)
mcolFiles.Remove AsyncProp.PropertyName
mcolData.Remove AsyncProp.PropertyName
RaiseEvent FileReadComplete( _
    GetFileKey(AsyncProp.PropertyName), _
    GetFileType(AsyncProp.PropertyName), _
    AsyncProp, _
    strData)
End Sub

Private Sub UserControl_AsyncReadProgress(AsyncProp As AsyncProperty)
Dim strData As String
strData = mcolData(AsyncProp.PropertyName)
RaiseEvent FileReadProgress( _
    GetFileKey(AsyncProp.PropertyName), _
    GetFileType(AsyncProp.PropertyName), _
    AsyncProp, _
    strData)
End Sub

Public Function DownloadFile( _
    ByVal strFileKey As String, _
    ByVal strPath As String, _
    ByVal lngFileType As enumDownloadFileTypes, _
    Optional ByVal strData As String) As Boolean
Dim lngAsyncFileType As Long
Dim blnRetVal As Boolean

'Initilaize
blnRetVal = True
strFileKey = Trim(strFileKey)

If Len(strFileKey) = 0 Then
    blnRetVal = False
End If

If blnRetVal Then
    'Translate the file type
    Select Case lngFileType
        Case dftFile
            lngAsyncFileType = vbAsyncTypeFile
        Case dftByteArray
            lngAsyncFileType = vbAsyncTypeByteArray
        Case dftPicture, _
            dftPicture16, _
            dftPicture32
            lngAsyncFileType = vbAsyncTypePicture
        Case Else
            'This is not a valid type
            blnRetVal = False
    End Select
End If

If blnRetVal Then
    'TODO: validate the URL
End If

If blnRetVal Then
    'Build the file key
    strFileKey = strFileKey & "|" & lngFileType
    'Check to see if the file is already being downloaded
    blnRetVal = AddFileKey(strFileKey)
    If blnRetVal Then
        mcolData.Add _
            strData, _
            strFileKey
    End If
End If

If blnRetVal Then
    'Start the retreival process
    UserControl.AsyncRead _
        strPath, _
        lngAsyncFileType, _
        strFileKey
End If
DownloadFile = blnRetVal
End Function

Private Function AddFileKey(strFileKey As String) As Boolean
On Error GoTo ERROR_AddFileKey
mcolFiles.Add _
    strFileKey, _
    strFileKey
AddFileKey = True
Exit Function
ERROR_AddFileKey:
AddFileKey = False
End Function

Private Sub UserControl_Initialize()
Set mcolFiles = New Collection
Set mcolData = New Collection
End Sub

Private Sub UserControl_Terminate()
Set mcolFiles = Nothing
Set mcolData = Nothing
End Sub
